#!/bin/bash

# Check if a directory list file was provided as an argument
if [ $# -ne 1 ]; then
  echo "Usage: $0 dirs_list_file"
  exit 1
fi

dirs_to_process="$1"

# Define log file for processed directories
processed_log="processed_visual_dirs_$(basename "$dirs_to_process").log"

# Read the list of directories to process into an array
mapfile -t dirs_array < "$dirs_to_process"

total_dirs=${#dirs_array[@]}
processed_count=0

# Define the processing function
process_dir() {
  dir="$1"
  target_dir="../../ht_selex/kmap_res"  # Target directory, same as in generate_dirs.sh
  output_dir="$target_dir/$dir"
  echo "Starting to process directory: $dir"
  
  ld_data_file="$output_dir/ld_data.csv"
  
  # Run Python script for plotting
  python plot_KMAP_UMAP_MDS_tSNE_PCA.py --out_dir "$output_dir"
  
  # Log the processed directory
  echo "$dir" >> "$processed_log"
  
  # Ensure log data is written to disk
  sync
  echo "Finished processing directory: $dir"
}

# Process each directory in sequence and display progress information
for dir in "${dirs_array[@]}"; do
  ((processed_count++))
  remaining=$((total_dirs - processed_count))
  echo "Processing directory $processed_count/$total_dirs, $remaining remaining."
  process_dir "$dir"
done
